﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;

public partial class Admin_NeiRong_RuanJian_ZhuanYi : System.Web.UI.Page
{
    private 访问 访问;
    protected String 分类代码;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("转移软件", "网站后台", "转移软件", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            转移软件();
        else
            初始化栏目();
    }

    private String 获取栏目代码(int ID)
    {
        if (ID == 0)
            return "";

        String 返回值 = "";
        SqlCommand 语句 = new SqlCommand("SELECT [栏目名称] FROM ["+程序.数据表前缀+"内容_栏目] WHERE [栏目类型]=@栏目类型 AND [ID]=" + ID, 访问.连接);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = "软件";
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
            返回值 = "<a href=\"FenLeiRuanJianNeiRongLieBiao.aspx?ID=" + ID + "\">" + Server.HtmlEncode(读取["栏目名称"].ToString()) + "</a> &gt;";
        else
        {
            读取.Close();
            throw new Exception("内容栏目不存在");
        }
        读取.Close();

        return 返回值;
    }

    private void 生成列表(DataSet 数据, int 父栏目, int 深度)
    {
        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
        {
            DataRow 行 = 数据.Tables[0].Rows[i];
            if (Convert.ToInt32(行["所属栏目"]) == 父栏目)
            {
                ListItem 列表项 = new ListItem(生成空格(深度) + Convert.ToString(行["栏目名称"]), Convert.ToString(行["ID"]));
                列表项.Attributes["style"] = Convert.ToBoolean(行["是否拥有子栏目"]) ? "" : "background:#eeeeee";
                LanMuWeiZhi.Items.Add(列表项);
                生成列表(数据, Convert.ToInt32(行["ID"]), 深度 + 1);
            }
        }
    }

    private String 生成空格(int 数量)
    {
        String 返回值 = "";
        for (int i = 0; i < 数量; i++)
            返回值 += "　";
        return 返回值 + "|-";
    }

    private void 初始化栏目()
    {
        int FID = Convert.ToInt32(Request.QueryString["fid"]);

        分类代码 = 获取栏目代码(FID);
        SqlCommand 语句;
        DataSet 数据 = new DataSet();
        语句 = new SqlCommand("SELECT [ID],[栏目名称],[所属栏目],[是否拥有子栏目] FROM ["+程序.数据表前缀+"内容_栏目] WHERE [栏目类型]=@栏目类型", 访问.连接);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = "软件";
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "内容栏目");

        生成列表(数据, 0, 1);
    }

    private void 转移软件()
    {
        访问.验证权限("16");
        String[] IDS = Request.QueryString["ID"].Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        int FID = Convert.ToInt32(Request.QueryString["fid"]);
        String rurl = Request.QueryString["rurl"];

        if (LanMuWeiZhi.SelectedValue == null || LanMuWeiZhi.SelectedValue == "")
            throw new Exception("请选择栏目位置");

        SqlCommand 语句 = new SqlCommand("UPDATE ["+程序.数据表前缀+"内容_软件_软件] SET [所属栏目]=@所属栏目 WHERE [ID]=@ID", 访问.连接);
        语句.Parameters.Add("@所属栏目", SqlDbType.Int).Value = Convert.ToInt32(LanMuWeiZhi.SelectedValue);
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = 0;

        for (int i = 0; i < IDS.Length; i++)
        {
            语句.Parameters["@ID"].Value = Convert.ToInt32(IDS[i]);
            语句.ExecuteNonQuery();
        }
        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("转移软件", 访问.用户["昵称"].ToString());

        Response.Redirect(rurl);
    }
}
